


	LIST P=16F628, R=DEC    ; Use the PIC16F628 and decimal system 

        #include "P16F628.INC"  ; Include header file 

         __config  _XT_OSC &_LVP_OFF & _WDT_ON & _PWRTE_ON & _BODEN_OFF 


	constant ENTER=0DH

pocet	equ	20H
flags	equ		22H
flags1	equ		23H
obeh	equ		24H
tmp		equ		25H
tmp_1	equ		26H
cas0	equ		27H
cas1	equ		28H
cas2	equ		29H

pamet_1		equ	 	30H	
pamet_2		equ		31H	
pamet_3		equ		32H	
pamet_4		equ		33H	
pamet_5		equ		34H	
pamet_6		equ		35H	
pamet_7		equ		36H	
pamet_8		equ		37H	
pamet_9		equ		38H	
pamet_10	equ		39H	
pamet_11	equ		3AH	
pamet_12	equ		3BH	
TMPW		equ		3CH
TMPS		equ		3DH
spojeni_ok	equ		01H
    

	ORG 0
	goto init	
	
	ORG 4
;int od seriove linky pouze pro test pripojeni mobilu	
	BCF		STATUS,RP0		;prijme znak z mobilu
	BTFSS	RCSTA,OERR
	GOTO	$+3
	BCF RCSTA,CREN
	BSF RCSTA,CREN
	MOVF RCREG,W
	movwf	tmp						;uloz znak do tempu
	bcf STATUS,Z
	movlw 'O'			;testuj znak OK - t.zn. pripojeni v poradku
	subwf tmp,w
	btfss STATUS,Z		;shoda = ven
	retfie
	bsf	flags1,spojeni_ok
	retfie 


;---------------casovaci rutina-----150 msec.--------------------------------
cekame	;Variables: TMP1, TMP0
;Delay 149996 cycles
       	clrwdt
        MOVLW 0x0E5  ;229 DEC
        MOVWF cas1
        MOVLW 0x0D9  ;217 DEC
        MOVWF cas0
        DECFSZ cas0,F
        GOTO $-1
        DECFSZ cas1,F
        GOTO $-5
;End of Delay
	return

;------------------casovaci rutina---------1 sec.
cekame_1	
;Delay 1000000 cycles
       	clrwdt
        MOVLW 0x15  ;21 DEC
        MOVWF cas2
        MOVLW 0x59  ;89 DEC
        MOVWF cas1
        MOVLW 0x0B1  ;177 DEC
        MOVWF cas0
        DECFSZ cas0,F
        GOTO $-1
        DECFSZ cas1,F
        GOTO $-5
        DECFSZ cas2,F
        GOTO $-9
	return

;-------Nacte pocet znaku ze seriaku podle cisla v W, vysledek je ve W-----------------------------------------------------
orizni	movwf tmp_1
opak	call receive	;nacti znak z MT
	decfsz tmp_1,f			
	goto opak
	return
;------------------------------------------------------------
;precte data z EEPROM
cti_eeprom		
	bsf	STATUS,RP0	; banka 1	!!! nastav EEADR !!!
	movlw 1
	movwf EEADR			;cti data z adresy 1 EEPROM
	bsf	EECON1,RD	; precte EEPROM
	movf	EEDATA,W	; EEDATA -> W
	bcf	STATUS,RP0	; banka 0
	return
;------------------------------------------------------------

;-----------------------Ulozi data do EEPROM------------------
zapis_eeprom
	movf flags,w				;priprav data do EEPROM
	bsf STATUS,RP0	; switch to bank 1
	movwf EEDATA
	movlw 1						;nacti adresu EEPROM
	movwf EEADR
	bsf	EECON1,WREN	; povolit zapis do EEPROM
;       ------------------------; aktivace zapisu
	movlw	0x55		; povinna povolovaci sekvence
	movwf	EECON2
	movlw	0xAA
	movwf	EECON2
	bsf	EECON1,WR	; spustit zapis
;       ------------------------; konec aktivace
	btfsc	EECON1,WR	; pockat na konec zapisu
	goto	$-1		; =1
	bcf	EECON1,WREN	; zakazat zapis do EEPROM
	bcf		STATUS,RP0	; banka 0
	return

;---------------------------------------------------------------
;-----------posle prikaz AT+ -----------------------
prikaz_AT	
	movlw 'A'
	call send
	movlw 'T'
	call send
	movlw '+'
	call send
	return
;---------------------------------------------------

;------------posle prikaz ATH a enter to je ZAVESIT--------------
zavesit
	movlw 'A'
	call send
	movlw 'T'
	call send
	movlw 'H'
	call send
	movlw ENTER
	call send
	return
;-----------------------------------------------------------------

;nuluje RAM 
null_ram	
	movlw 0FFH
	movwf pamet_1
	movwf pamet_2
	movwf pamet_3
	movwf pamet_4
	movwf pamet_5
	movwf pamet_6
	movwf pamet_7
	movwf pamet_8
	movwf pamet_9
	movwf pamet_10
	movwf pamet_11
	movwf pamet_12
	return

cti_znaky	
	call receive			;cti 12znaku ze seriaku
	movwf pamet_1
	call receive
	movwf pamet_2
	call receive
	movwf pamet_3
	call receive
	movwf pamet_4
	call receive
	movwf pamet_5
	call receive
	movwf pamet_6
	call receive
	movwf pamet_7
	call receive
	movwf pamet_8
	call receive
	movwf pamet_9
	call receive
	movwf pamet_10
	call receive
	movwf pamet_11
	call receive
	movwf pamet_12
	return
	
;-----------------vycteni telef. cisla z MT --------------------
;posli prikaz
vycti_cislo
	call prikaz_AT
	movlw 'C'
	call send
	movlw 'P'
	call send
	movlw 'B'
	call send
	movlw 'R'
	call send
	movlw '='
	call send
	movlw '1'
	call send
	movlw ENTER
	call send
;---cti data z MT---------------------
pokr_07
	call receive			;cti jeden znak
	bcf STATUS,Z
	sublw 	'"'				;testuj dosazeni ASCII znaku uvozovek,pokud nejsou,cti znovu seriak
	btfss STATUS,Z
	goto pokr_07
	movlw 1H					;prisly uvozovky,zacina tlf. cislo,zadej do W
	call orizni					;precte znak + a zahodi ho,bude pridan pri volani cisla
	call cti_znaky				;precte 12 znaku ze seriaku
	call cekame					;odcasuje
	return

;-----------------vytoci telefonni cislo-------------------------
;prikaz
volej_cislo	
	movlw	'A'
	call send
	movlw 'T'
	call send
	movlw 'D'
	call send
	movlw '+'
	call send
;doplni prikaz tel. cislem z pameti
	movf pamet_1,w
	call send
	movf pamet_2,w
	call send
	movf pamet_3,w
	call send
	movf pamet_4,w
	call send
	movf pamet_5,w
	call send
	movf pamet_6,w
	call send
	movf pamet_7,w
	call send
	movf pamet_8,w
	call send
	movf pamet_9,w
	call send
	movf pamet_10,w
	call send
	movf pamet_11,w
	call send
	movf pamet_12,w
	call send
	movlw ';'
	call send
	movlw ENTER
	call send
	call cekame_1
	call cekame_1
	call cekame_1
	call cekame_1
	call cekame_1
	call cekame_1
	call cekame_1
	call cekame_1
	call cekame_1		;zvoni,zvoni, casovaci rutiny
	call cekame_1
	call cekame_1
	call cekame_1
	call cekame_1
	call cekame_1
	call cekame_1
	call zavesit	;zavesi
	call cekame		;odcasuje
	return


	
;
init
	movlw 7
	movwf CMCON		; CMCON=7 set comparators off         

	bcf STATUS,RP0	; switch to bank 0
	bcf STATUS,RP1
	movlw b'00000000' ;kvuli prechodu do nabijeni je nejprve out linka  v L na cca 2 sec
	movwf PORTB
	call cekame_1		;cekej sekundu	
	call cekame_1		;cekej sekundu
	movlw b'00000100'
	movwf PORTB
	bsf		PORTA,3	;LED zhasnuta

; 
; ---------------- 
; INITIALIZE PORTS
; ---------------- 
; 
        bsf STATUS,RP0          ; RAM PAGE 1
		bcf OPTION_REG, 7		; enable internal pullups
        movlw b'11110111'		;port RA3 is OUT
        movwf TRISA		; portA

;----------PORT B-----------------------
       movlw b'11101011'	;  input is all, port B pins 2 and 4 is out 
       movwf TRISB
	
; ------------------------------------
; SET BAUD RATE TO COMMUNICATE WITH MT SIEMENS C35
; ------------------------------------
; Boot Baud Rate = 19200, No Parity, 1 Stop Bit
        movlw 0x0C              ; 0x0C=19200 bps
        movwf SPBRG
        movlw b'00100100'       ; brgh = high (2)
        movwf TXSTA             ; enable Async Transmission, set brgh
 
 
 ;nastaveni WATCHDOGU
 		bsf	OPTION_REG,PS0			;preddelicka 1:128
 		bsf	OPTION_REG,PS1
 		bsf	OPTION_REG,PS2
 		bsf	OPTION_REG,PSA			;preddelicka watchdog
 		
 
        bcf STATUS,RP0          ; RAM PAGE 0

    	movlw b'10010000'       ; enable Async Reception
        movwf RCSTA	
		clrf	flags
		clrf	flags1
				
				
	 	
;-----------------HLAVNI SMYCKA---------------------------
;pri spusteni poplachu testuje 10 sec., zda nebylo tlacitko stisknuto,pokud ne vola MT. Pokud ano, dojde k odstaveni
;az do dalsi deaktivace poplachu (zabouchnuti dveri). Pak jiz zase pracuje normalne
zacatek	bcf STATUS,RP0	; switch to bank 0
	call null_ram		;nuluj RAM
	call cti_eeprom		;rutina cteni z eeprom
	movwf flags			;testuj data
	btfsc flags,0		;pokud je nula,bylo pred resetem rele vypnute
	goto zapni			;jinak bylo zapnute, zapni a pokracuj
	bcf PORTB,4			;vypni rele
	goto pokr_01
zapni	bsf PORTB,4
pokr_01	nop
	btfss flags1,7		;testuj priznak OK prijmu SMS, nastaven=prozvon
	goto pokr_02
	call cekame_1
	call cekame_1
	call cekame_1
	call vycti_cislo	;vycteni tlf. cisla z MT
	call volej_cislo	;vytoci tlf.cislo
	call null_ram		;nuluje RAM pro tlf. cislo
	bcf flags1,7		;prozvoneno po SMS, shod flag
;
pokr_02	bsf PORTA,3		;zhasni LED
	call	test_pripojeni
	call cekame			;volani casovaci rutiny
	bcf PORTA,3			;rozsvit LED
	movlw 0AH			;nacti hodnotu poctu obehu programu
	movwf obeh			;uloz na adresu
test
	btfsc PORTB,0		;testuj vstup poplachu,pokud je poplach, je bit v L
	goto pokr_03		;neni poplach, pokracuj
	btfsc flags1,0		;byl uz volan poplach?
	goto pokr_04		;ano, znovu nevolej
	bsf flags1,0		;nastav flag zda byl uz poplach vyvolan - pri pozadavku rucniho spusteni pred opustenim presunout nastaveni tohoto
						;priznaku do rutiny s navestim poplach na zacatek 
	movlw	0AH			;nacti pocet opakovani 1 sec. zpozdeni na 10x cili 10 sec.
	movwf	pocet			;uloz na adresu
opak_08
	btfss	PORTB,3		;testuj,pokud je v H,tak se odcasuje,v L poplach odstaven
	goto	pokr_04			;pokud je v H,testuj 10 vterin stav,pokud prejde do 
	call cekame_1			;casovaci rutina 10x cca 1,1 sec.
	btfss	PORTA,3		;tohle smeti je jen kvuli blikani LED (jo neni nad instrukci CPL u x51)
	goto	zhasni
	bcf PORTA,3			;rozsvit LED
	goto	pokr_1
zhasni	bsf PORTA,3		;zhasni LED
pokr_1	
		decfsz	pocet	;dekrementuj pocet opakovani	
	goto	opak_08		;znovu testuj odstaveni poplachu a cekej 1 sec.		
poplach
	bcf PORTA,3			;rozsvit LED	;aby zustala svitit po blikani v casovani vyse 
	call vycti_cislo			;vycteni tlf. cisla z mobilu
	call volej_cislo			;vytoci tlf.cislo
	call null_ram						;nuluje RAM pro dalsi tlf. cislo
	goto pokr_04
pokr_03	bcf flags1,0		;neni poplach,nuluj flag volani poplachu
pokr_04	bcf PORTA,3			;rozsvit LED
	call cekame_1		;pauza
	decfsz obeh,f		;dekrementuj pocet obehu,a opakuj 10x a pokazde otestuj vstup poplachu
	goto test

;dal se cyklicky dotazuje mobilu na prijeti nove SMS
	call prikaz_AT			;vysli prikaz AT+
	movlw 'C'
	call send
	movlw 'M'
	call send
	movlw 'G'
	call send
	movlw 'L'
	call send
	movlw '='
	call send
	movlw '0'
	call send
	movlw ENTER
	call send						;vypise prijate neprectene zpravy
pokr_06	
	call receive					;prijme znak z mobilu
	movwf	tmp						;uloz znak do tempu
	bcf STATUS,Z
	movlw 'O'			;testuj znak OK - t.zn. neni nova SMS
	subwf tmp,w
	btfsc STATUS,Z		;je znak O, volej rutinu smazani aktualni SMS
	goto smaz_sms		;pokud je O, volej smazani SMS
	movlw ':'			;testuj dosazeni dvojtecky
	subwf tmp,w
	btfss STATUS,Z
	goto pokr_06		;dvojtecka neni.opakuj		
	movlw 42H	; 					;nacti do W pocet ctenych byte z MT
	call orizni						;zahodi 66 byte ze seriaku a tim jsem na zacatku platnych dat sms
	call cti_znaky					;precte a ulozi 12 byte ze seriaku POZOR,pokud se meni sms pro ovladani,musi se zmenit i toto cislo
	movlw '6'						;zacne porovnavat,tato data jsou pro zapnuti
	bcf STATUS,Z
	subwf pamet_1,w
	btfss STATUS,Z					;pokud se rovna pokracuj dal,pokud se nerovna pokracuj na test druhe SMS
	goto druha_sms	
	movlw '9'
	bcf STATUS,Z
	subwf pamet_2,w
	btfss STATUS,Z
	goto druha_sms
	movlw 'B'
	bcf STATUS,Z
	subwf pamet_3,w
	btfss STATUS,Z
	goto druha_sms
	movlw '3'
	bcf STATUS,Z
	subwf pamet_4,w
	btfss STATUS,Z
	goto druha_sms
	movlw 'A'
	bcf STATUS,Z
	subwf pamet_5,w
	btfss STATUS,Z
	goto druha_sms
	movlw '5'
	bcf STATUS,Z
	subwf pamet_6,w
	btfss STATUS,Z
	goto druha_sms
	movlw '0'
	bcf STATUS,Z
	subwf pamet_7,w
	btfss STATUS,Z
	goto druha_sms
	movlw 'D'
	bcf STATUS,Z
	subwf pamet_8,w
	btfss STATUS,Z
	goto druha_sms
	movlw '4'
	bcf STATUS,Z
	subwf pamet_9,w
	btfss STATUS,Z
	goto druha_sms
	movlw '2'
	bcf STATUS,Z
	subwf pamet_10,w
	btfss STATUS,Z
	goto druha_sms
	movlw '0'
	bcf STATUS,Z
	subwf pamet_11,w
	btfss STATUS,Z
	goto druha_sms
	movlw '1'
	bcf STATUS,Z
	subwf pamet_12,w
	btfss STATUS,Z
	goto druha_sms
	bsf flags,0					;prijata zprava je tahle, vysledek porovnani je OK,nastav flag pro zapnuti rele
	call zapis_eeprom			;zapis data do EEPROM
	bsf flags1,7					;nastav flag ze zprava byla OK prijata
	goto smaz_sms					;pokracuj smazanim zpravy
druha_sms	movlw '6'
	bcf STATUS,Z
	subwf pamet_1,w
	btfss STATUS,Z
	goto smaz_sms				;pokud se nerovna, je to neplatna SMS, smaz ji a nedelej nic
	movlw '9'
	bcf STATUS,Z
	subwf pamet_2,w
	btfss STATUS,Z
	goto smaz_sms				;pokud se nerovna, je to neplatna SMS, smaz ji a nedelej nic
	movlw 'B'
	bcf STATUS,Z
	subwf pamet_3,w
	btfss STATUS,Z
	goto smaz_sms				;pokud se nerovna, je to neplatna SMS, smaz ji a nedelej nic
	movlw '3'
	bcf STATUS,Z
	subwf pamet_4,w
	btfss STATUS,Z
	goto smaz_sms				;pokud se nerovna, je to neplatna SMS, smaz ji a nedelej nic
	movlw '6'
	bcf STATUS,Z
	subwf pamet_5,w
	btfss STATUS,Z
	goto smaz_sms
	movlw '5'
	bcf STATUS,Z
	subwf pamet_6,w
	btfss STATUS,Z
	goto smaz_sms
	movlw 'C'
	bcf STATUS,Z
	subwf pamet_7,w
	btfss STATUS,Z
	goto smaz_sms
	movlw 'D'
	bcf STATUS,Z
	subwf pamet_8,w
	btfss STATUS,Z
	goto smaz_sms
	movlw '4'
	bcf STATUS,Z
	subwf pamet_9,w
	btfss STATUS,Z
	goto smaz_sms
	movlw '2'
	bcf STATUS,Z
	subwf pamet_10,w
	btfss STATUS,Z
	goto smaz_sms
	movlw '0'
	bcf STATUS,Z
	subwf pamet_11,w
	btfss STATUS,Z
	goto smaz_sms
	movlw '1'
	bcf STATUS,Z
	subwf pamet_12,w
	btfss STATUS,Z
	goto smaz_sms
	bcf flags,0				;prijata zprava je tahle, vysledek porovnani je OK,nastav flag pro vypnuti rele
	call zapis_eeprom		;vypal data
	bsf flags1,7			;nastav flag pro prozvonei,ze SMS byla OK prijata
					;a pokracuj smazanim SMS
;--------------smaze SMS,cislo v prikazu udava pozici zpravy,ktera ma byt smazana
smaz_sms
	call prikaz_AT				;posli AT+
	movlw 'C'
	call send
	movlw 'M'
	call send
	movlw 'G'
	call send
	movlw 'D'
	call send
	movlw '='
	call send
	movlw '1'
	call send
	movlw ENTER
	call send
	goto zacatek			;zpet na zacatek 


test_pripojeni	;posila cyklicky dotaz do mobilu, dokud nedostane ok nejde ven
	clrwdt
	bcf	flags1,spojeni_ok
	bsf	STATUS,RP0		;bank 1
	bsf	PIE1,RCIE		;povol INT od seriove linky	
	bsf	INTCON,PEIE
	bsf	INTCON,GIE
	bcf STATUS,RP0
	movlw 'A'
	call send
	movlw 'T'
	call send
	movlw ENTER
	call send
	call	cekame_1
	btfss	flags1,spojeni_ok		;nastavovan v INT
	goto	test_pripojeni
	
	
	bsf	STATUS,RP0		;bank 1
	bsf	INTCON,GIE
	bsf	INTCON,PEIE
	bcf	PIE1,RCIE		;zakaz INT od seriove linky	
	bcf STATUS,RP0
	
	return

; -------------------------------------------
; RECEIVE CHARACTER FROM RS232 AND STORE IN W
; -------------------------------------------
; This routine does not return until a character is received.
;
receive 
	clrwdt
	BCF		STATUS,RP0
	BTFSS	RCSTA,OERR
	GOTO	$+3
	BCF RCSTA,CREN
	BSF RCSTA,CREN
	BTFSS PIR1,RCIF
	GOTO $-1
	MOVF RCREG,W
	RETURN

;
; -------------------------------------------------------------
; SEND CHARACTER IN W VIA RS232 AND WAIT UNTIL FINISHED SENDING 
; -------------------------------------------------------------
;
send    clrwdt
		movwf TXREG             ; send data in W 

TransWt bsf STATUS,RP0		; RAM PAGE 1
WtHere  btfss TXSTA,TRMT        ; (1) transmission is complete if hi
        goto WtHere

        bcf STATUS,RP0          ; RAM PAGE 0
        return
;








	END
